/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_AUDIO_STREAM_DECODER_H__
#define BMD_AUDIO_STREAM_DECODER_H__

#include <AudioToolbox/AudioFileStream.h>
#include <AudioToolbox/AudioQueue.h>
#include <pthread.h>

const int kBufferCount = 4;

class AudioStreamDecoder
{
	public:
								AudioStreamDecoder();
		virtual					~AudioStreamDecoder();

		long					Init();
		long					Start();
		long					Stop();
		long					EnqueueData(const void* data, unsigned int length, bool discontinuous);

	protected:
		static void				StaticQueueRunningCallback(void* context, AudioQueueRef queue, AudioQueuePropertyID property);
		static void				StaticBufferCompleteCallback(void* context, AudioQueueRef queue, AudioQueueBufferRef buffer);
		static void				StaticPropertyCallback(void* context, AudioFileStreamID stream, AudioFileStreamPropertyID property, UInt32* flags);
		static void				StaticPacketCallback(void* context, UInt32 byteCount, UInt32 packetCount, const void* data, AudioStreamPacketDescription* packetDescriptions);

		void					QueueRunningCallback(AudioQueueRef queue, AudioQueuePropertyID property);
		void					BufferCompleteCallback(AudioQueueRef queue, AudioQueueBufferRef buffer);
		void					PropertyCallback(AudioFileStreamID stream, AudioFileStreamPropertyID property, UInt32* flags);
		void					PacketCallback(UInt32 byteCount, UInt32 packetCount, const void* data, AudioStreamPacketDescription* packetDescriptions);

		long					EnqueueBuffer();
		long					SetFinished();

		AudioFileStreamID		mStream;
		AudioQueueRef			mQueue;
		bool					mStarted;
		bool					mFinished;
		AudioQueueBufferRef		mBuffers[kBufferCount];
		AudioQueueBufferRef*	mCurrentBuffer;
		pthread_mutex_t			mMutex;
		pthread_cond_t			mCond;
};

#endif /* BMD_AUDIO_STREAM_DECODER_H__ */
